  /**
   * // === Step 1: Activate Orb of Ascension use ===
ItemEvents.rightClicked('kubejs:orb_of_ascension', event => {
    let player = event.player
    if (activeTags.some(tag => player.tags.contains(tag))) {
        player.tell(Text.red('You are already under the effects of another Orb.'))
        return
    }
    let orb = event.item
    event.player.tell(Text.gray('Drop the item to upgrade it.').italic())
    player.tags.add('orb_of_ascension_drop')
    orb.count--

    Utils.server.runCommandSilent(`/execute at ${player.username} run particle born_in_chaos_v1:infernal_surge ${player.x} ${player.y} ${player.z} 1 1 1 1 100 force ${player.username}`)
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run playsound alexscaves:abyssmarine_glow_on player ${event.player.username} ${event.player.x} ${event.player.y} ${event.player.z} 1 1.8`)
})



ItemEvents.pickedUp(event => {
    let player = event.player
    if (!player.tags.contains('orb_of_ascension')) return
  
    let item = event.item
    if (!item || !item.nbt || !item.nbt.affix_data || !item.nbt.affix_data.affixes) {
      player.tell(Text.red('That item holds no affixes to empower.'))
      player.tags.remove('orb_of_ascension')
      spawnItem('kubejs:orb_of_ascension', 1, player)
      return
    }
  
    // Put the item into main hand for command to work
    putInMainhand(player, item)
  
    item = player.mainHandItem
  
    Utils.server.scheduleInTicks(1, () => {
        let success = upgradeRandomAffix(player, item)
        player.tags.remove('orb_of_ascension')
  
        if (success) {
          Utils.server.runCommandSilent(`/execute at ${player.username} run playsound minecells:charge player ${player.username} ${player.x} ${player.y} ${player.z} 1 0.7`)
          Utils.server.runCommandSilent(`/execute at ${player.username} run particle irons_spellbooks:fire ${player.x} ${player.y} ${player.z} 0.2 0.2 0.2 0.5 200 force ${player.username}`)
        } else {
          spawnItem('kubejs:orb_of_ascension', 1, player)
        }
    })
  })

   * 
   * 
   * 
   * 
   */


    /**
   * 
   * ItemEvents.rightClicked('kubejs:orb_of_corruption', event => {
  let player = event.player
    if (activeTags.some(tag => event.player.tags.contains(tag))) {
      event.player.tell(Text.red('You are already under the effects of another Orb.'))
      return
  }
    if (event.player.tags.contains('orb_of_corruption')) return
    event.player.tags.add('orb_of_corruption_drop')
    event.player.persistentData.putString('orb_of_corruption_item', event.item.id)
    event.item.count--
    Utils.server.runCommandSilent(`/execute in ${event.player.level.dimension} run particle born_in_chaos_v1:chaosenergy ${event.player.x} ${event.player.y+1} ${event.player.z} 1 1 1 0.5 200`)
    Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound born_in_chaos_v1:charm_of_rage_use ambient ${event.player.username} ${event.player.x} ${event.player.y} ${event.player.z} 1 1.7`)
})
// === Chaos Anomaly (Orb of Corruption) — Scales with Rarity ===


// Main handler
ItemEvents.pickedUp(event => {
  let player = event.player
  let item = event.item

  if (!player.tags.contains('orb_of_corruption')) return

  if (item.nbt?.ChaosAnomalyUsed) {
    player.tell(Text.red("§cThis item has already been touched by Corruption."))
    player.tags.remove('orb_of_corruption')
    spawnItem('kubejs:orb_of_corruption', 1, player)
    player.persistentData.remove('orb_of_corruption_item')
    return
  }
  Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle born_in_chaos_v1:ritual ${player.x} ${player.y + 1} ${player.z} 0.5 0.5 0.5 1 100`)
  Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound minecraft:entity.wither.spawn ambient ${event.player.username} ${event.player.x} ${event.player.y} ${event.player.z} 1 1.5`)
  
  putInMainhand(player, item)
  let rarity_check = itemRarityCheck(player, item)
  if (!rarity_check) {
    player.tell(Text.of([Text.of('Your item must be at least').red(), Text.of(' Common ').gray(), Text.of('rarity to Corrupt this item.').red()]))
    player.tags.remove('orb_of_corruption')
    spawnItem('kubejs:orb_of_corruption', 1, player)
    return false
  }
  Utils.server.scheduleInTicks(1, () => {
    const held = player.mainHandItem
    if (!held || !held.nbt) return

    const rarity = held.nbt.affix_data?.rarity || 'apotheosis:common'
    const hasLuck = player.hasEffect('kubejs:arcane_luck')

    const corruptionOdds = {
      'apotheosis:common':    { destroy: 0.60, nothing: 0.30, extraAffix: 0.03, extraSpell: 0.03, spellUpgrade: 0.04 }, // Total: 1.00
      'apotheosis:uncommon':  { destroy: 0.50, nothing: 0.25, extraAffix: 0.05, extraSpell: 0.10, spellUpgrade: 0.10 }, // Total: 1.00
      'apotheosis:rare':      { destroy: 0.40, nothing: 0.20, extraAffix: 0.10, extraSpell: 0.15, spellUpgrade: 0.15 }, // Total: 1.00
      'apotheosis:epic':     { destroy: 0.35, nothing: 0.15, extraAffix: 0.17, extraSpell: 0.17, spellUpgrade: 0.16 }, // Total: 1.00
      'apotheosis:mythic':   { destroy: 0.30, nothing: 0.15, extraAffix: 0.17, extraSpell: 0.19, spellUpgrade: 0.19 }, // Total: 1.00
      'apotheosis:ancient':  { destroy: 0.25, nothing: 0.15, extraAffix: 0.20, extraSpell: 0.20, spellUpgrade: 0.20 }, // Total: 1.00
    }

    const odds = corruptionOdds[rarity] || corruptionOdds['apotheosis:common']
    const roll = Math.random()
    // Destroy outcome
    if (roll < odds.destroy) {
      player.mainHandItem.count = 0
      player.setMainHandItem(Item.of('supplementaries:ash'))
      player.tags.remove('orb_of_corruption')
      player.persistentData.remove('orb_of_corruption_item')
      

      player.tell('§cThe Corruption devours the item entirely.')
      return
    }

    // Nothing happens
    if (roll < odds.destroy + odds.nothing) {
      player.tags.remove('orb_of_corruption')
      player.persistentData.remove('orb_of_corruption_item')
      player.tell('The Corruption flickers... but nothing happens.')
      return
    }

    // Begin modification
    player.persistentData.putBoolean('chaos_override_caps', true)

    // Upgrade rarity
    upgradeItemRarity(player, held)
    // Add base affix
    addAffix(held, player)

    // Extra affixes
    const rolls = hasLuck ? 2 : 1
    for (let i = 0; i < rolls; i++) {
      if (Math.random() < odds.extraAffix) {
        addAffix(held, player)
        player.tell(Text.lightPurple('§cThe anomaly forces another affix into the item...'))
      }
    }

    // Imbue spells
    imbueItem(player)
    if (Math.random() < odds.extraSpell) {
      imbueItem(player)
      player.tell(Text.lightPurple('§bA second spell is etched into the item...'))
    }

    // Upgrade spells
    upgradeImbuedSpell(player, held)
    if (Math.random() < odds.spellUpgrade) {
      upgradeImbuedSpell(player, held)
      player.tell(Text.lightPurple('§dThe corruption amplifies your spell beyond expectation.'))
    }

    // Add sockets
    addSockets(player, held, hasLuck ? 4 : 2, true)

    // Mark as corrupted
    let display = held.nbt.display || {};
    let loreList = display.Lore || [];
    let newLore = [];

    // Copy existing lines
    for (let i = 0; i < loreList.length; i++) {
      newLore.push(loreList[i]);
    }

    // Add “CORRUPTED” if it isn’t already there
    if (!newLore.some(line => line.toString().includes('CORRUPTED'))) {
      // Push a raw JSON string, just like the cleanse uses String() on each element
      newLore.push(JSON.stringify({ text: 'CORRUPTED', color: 'dark_red', italic: true }));
    }

    // Write it back to the held item
    held.nbt.display = held.nbt.display || {};
    held.nbt.display.Lore = newLore;
    held.nbt.ChaosAnomalyUsed = true;




    // Cleanup tags and persistent data
    player.tags.remove('orb_of_corruption')
    player.persistentData.remove('orb_of_corruption_item')
    player.persistentData.remove('chaos_override_caps')
    player.persistentData.remove('sockets')

    player.tell('§4The Corruption reshapes your item...')
  })
})

   * 
   * 
   * 
   */

  /**
   * 
// === Right-click to activate Orb of Reweaving
ItemEvents.rightClicked('kubejs:orb_of_dissonance', event => {
    if (activeTags.some(tag => event.player.tags.contains(tag))) {
      event.player.tell(Text.red('You are already under the effects of another Orb.'))
      return
  }
  Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle rats:rat_lightning ${event.player.x} ${event.player.y+1} ${event.player.z} 1 1 1 1 50`)
  Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run playsound alexsmobs:guster_idle ambient ${event.player.username} ${event.player.x} ${event.player.y} ${event.player.z} 1 1`)
  
    event.player.tags.add('orb_of_dissonance_drop')
    event.item.count--
  })
  
  ItemEvents.pickedUp(event => {
    const player = event.player
    const item = event.item
    if (!player.tags.contains('orb_of_dissonance')) return
    player.tags.remove('orb_of_dissonance')
  
    Utils.server.scheduleInTicks(1, () => {
      let stack = player.mainHandItem
      if (!stack || !stack.nbt || !stack.nbt.ISB_Spells || !stack.nbt.ISB_Spells.data) {
        player.tell(Text.red("That item holds no spells to modify."))
        spawnItem('kubejs:orb_of_dissonance', 1, player)
        return
      }
  
      let spellTag = stack.nbt.ISB_Spells
      let spellList = spellTag.data
  
      if (spellList.length < 3) {
        player.tell(Text.red("You need at least 3 spells to reweave."))
        spawnItem('kubejs:orb_of_dissonance', 1, player)
        return
      }
  
      // Choose a spell to remove
      let removeIndex = Math.floor(Math.random() * spellList.length)
      let removedSpell = spellList[removeIndex]
  
      // Rebuild list without removed spell
      let newList = []
      for (let i = 0; i < spellList.length; i++) {
        if (i !== removeIndex) {
          newList.push(spellList[i])
        }
      }
  
      spellTag.data = newList
      spellTag.maxSpells = Math.max(spellTag.maxSpells ?? newList.length, newList.length)
      stack.nbt.ISB_Spells = spellTag
  
      // Format removed name
      let removedName = removedSpell.id.split(':').pop().split('_').map(w => w.charAt(0).toUpperCase() + w.slice(1)).join(' ')
      player.tell(Text.red(`[Removed spell]: `).append(Text.gray(removedName)))
  
      // Add a new spell using existing function
      Utils.server.scheduleInTicks(2, () => {
        imbueItem(player)
      })
  
      // Visuals
      Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run playsound alexsmobs:guster_idle ambient ${event.player.username} ${event.player.x} ${event.player.y} ${event.player.z} 1 2`)
      Utils.server.runCommandSilent(`/execute at ${player.username} run particle minecraft:enchant ~ ~1 ~ 0.65 0.65 0.65 0.02 150`)
    })
  })
  
   * 
   * 
   * 
   * 
   */


  // === Step 1: Activate blueprint ===



  /**
   * ItemEvents.rightClicked('kubejs:orb_of_exaltation', event => {
  if (activeTags.some(tag => event.player.tags.contains(tag))) {
    event.player.tell(Text.red('You are already under the effects of another Orb.'))
    return
}
    let player = event.player
    player.tags.add('orb_of_exaltation_drop')
    event.item.count--

    Utils.server.runCommandSilent(`/execute at ${player.username} run particle born_in_chaos_v1:infernaltrail ~ ~ ~ 1 1 1 0.3 50`)
    Utils.server.runCommandSilent(`/execute at ${player.username} run playsound born_in_chaos_v1:charm_of_endurance_use ambient ${player.username} ~ ~ ~ 1 1.5`)
})

   * 
   * ItemEvents.pickedUp(event => {
    let player = event.player
    if (!player.tags.contains('orb_of_exaltation')) return

    let item = event.item
    // Dont apply if item is not common
    let rarity_check = itemRarityCheck(player, item)
    if (!rarity_check) {
      player.tell(Text.of([Text.of('Your item must be at least').red(), Text.of(' Common ').gray(), Text.of('rarity').red()]))
      player.tags.remove('orb_of_exaltation')
      spawnItem('kubejs:orb_of_exaltation', 1, player)
      return
    }

    // Move item to main hand
    putInMainhand(player, item)

    Utils.server.scheduleInTicks(1, () => {
        let rarity = upgradeItemRarity(player, player.mainHandItem)
        if (!rarity) {
            player.tags.remove('orb_of_exaltation')
            spawnItem('kubejs:orb_of_exaltation', 1, player)
            return
        }
    })
})

   * 
   * 
   */
  /**
   * 
   * ItemEvents.rightClicked('kubejs:orb_of_imbuement', event => {
    event.item.count -= 1
    if (activeTags.some(tag => event.player.tags.contains(tag))) {
        event.player.tell(Text.red('You are already under the effects of another Orb.'))
        spawnItem('kubejs:orb_of_imbuement', 1, event.player)
        return
    }
    event.player.tags.add(`orb_of_imbuement_drop`)
    event.player.tell(Text.gray('Drop the item to imbue it.').italic())
    
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle alexscaves:blue_hazmat_breathe ${event.player.x} ${event.player.y+1} ${event.player.z} 1 1 1 1 500`)
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run playsound alexscaves:abyssmarine_glow_on ambient ${event.player.username} ${event.player.x} ${event.player.y} ${event.player.z} 1 2`)
})







ItemEvents.pickedUp(event => {
    let player = event.player
    let item = event.item
    // Only trigger if the player has a sentient stone tag
    if (!player.tags.contains('orb_of_imbuement')) return

    // Only apply to valid items
    if (
        !apoth.lootify_valid.some(valid => item.toString().includes(valid)) &&
        !isCurioItem(item)
      ) return
      
    // === Move item to main hand ===
    putInMainhand(player, item)
    Utils.server.scheduleInTicks(1, () => {
        let success = imbueItem(player)
        player.tags.remove('orb_of_imbuement')
        if (!success) {
            spawnItem('kubejs:orb_of_imbuement', 1, player)
            return
        }
        
    })
})


   * 
   * 
   * 
   */



  
  // ==== ORB ACTIVATION ====
  /**
   *   ItemEvents.rightClicked('kubejs:orb_of_infusion', event => {
    if (activeTags.some(tag => event.player.tags.contains(tag))) {
      event.player.tell(Text.red('You are already under the effects of another Orb.'))
      return
  }
    event.player.persistentData.orb_mode = 'infusion'
    event.player.tags.add('orb_of_infusion_drop') // Add a tag to the player to signify they have the orb
    event.player.tell(Text.darkGray('Drop the item to infuse it.').italic())
    event.item.count--
    let player = event.player
    Utils.server.runCommandSilent(`/execute at ${player.username} run particle irons_spellbooks:wisp ${player.x} ${player.y} ${player.z} 0.5 0.5 0.5 0.2 250`)
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run playsound alexscaves:abyssmarine_glow_on player ${event.player.username} ${event.player.x} ${event.player.y} ${event.player.z} 1 2`)
  })
  
  ItemEvents.rightClicked('kubejs:orb_of_reforging', event => {
    if (activeTags.some(tag => event.player.tags.contains(tag))) {
      event.player.tell(Text.red('You are already under the effects of another Orb.'))
      return
  }
    event.player.persistentData.orb_mode = 'reforging'
    event.player.tags.add('orb_of_reforging_drop') // Add a tag to the player to signify they have the orb
    event.player.tell(Text.gray('Drop the item to reforge it.').italic())
    event.item.count--
    let player = event.player
    Utils.server.runCommandSilent(`/execute at ${player.username} run particle irons_spellbooks:portal_frame ${player.x} ${player.y} ${player.z} 1.0 1.0 1.0 2 200`)
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run playsound alexscaves:abyssmarine_glow_on player ${event.player.username} ${event.player.x} ${event.player.y} ${event.player.z} 1 2`)
  })
  
  ItemEvents.pickedUp(event => {
    let player = event.player
    let item = event.item
    let mode = player.persistentData.orb_mode
    if (!mode || !item) return
            // Move into main hand
    putInMainhand(player, item)
        item = player.mainHandItem
        Utils.server.scheduleInTicks(1, () => {
            if (mode === 'infusion') {
                if (!player.tags.contains('orb_of_infusion')) return
                player.tags.remove('orb_of_infusion')
                let infuse = addAffix(player, item)
                if (infuse) {
                    Utils.server.runCommandSilent(`/execute at ${player.username} run playsound irons_spellbooks:spell.thunderstorm.prepare player ${player.username} ${player.x} ${player.y} ${player.z} 1 1.5`)
                    Utils.server.runCommandSilent(`/execute at ${player.username} run particle irons_spellbooks:electricity ${player.x} ${player.y} ${player.z} 0.2 0.2 0.2 0.5 200 force ${player.username}`)
                } else {
                    spawnItem('kubejs:orb_of_infusion', 1, player)
                }
            } else if (mode === 'reforging') {
                if (!player.tags.contains('orb_of_reforging')) return
                player.tags.remove('orb_of_reforging')
                let remove = removeAffix(player, item)
                if (remove) {
                  Utils.server.runCommandSilent(`/execute at ${player.username} run playsound irons_spellbooks:spell.thunderstorm.prepare player ${player.username} ${player.x} ${player.y} ${player.z} 1 1.5`)
                  Utils.server.runCommandSilent(`/execute at ${player.username} run particle irons_spellbooks:fire ${player.x} ${player.y} ${player.z} 0.2 0.2 0.2 0.5 200 force ${player.username}`)
                } else {
                    spawnItem('kubejs:orb_of_reforging', 1, player)
                }
              }
            player.persistentData.remove('orb_mode')
          })
  })



   * 
   * 
   * 
   * 
   */



  /**
   * 
   *   ItemEvents.rightClicked('kubejs:orb_of_repentance', event => {
    if (activeTags.some(tag => event.player.tags.contains(tag))) {
      event.player.tell(Text.red('You are already under the effects of another Orb.'))
      return
  }
    event.player.tell(Text.darkAqua("Drop the item you wish to cleanse"))
    event.player.tags.add('orb_of_repentance_drop') // Will activate when dropped on Scroll Forge
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle yungscavebiomes:ice_shatter ${event.player.x} ${event.player.y+1} ${event.player.z} 0 0 0 0.0005 100`)
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run playsound alexscaves:abyssmarine_glow_on ambient ${event.player.username} ${event.player.x} ${event.player.y} ${event.player.z} 1 2`)
    event.item.count -= 1
  })
  
  ItemEvents.pickedUp(event => {
    let player = event.player
    if (!player.tags.contains('orb_of_repentance')) return
  
    putInMainhand(player, event.item)
    if (!event.item.nbt.contains('ChaosAnomalyUsed')) {
      player.tell(Text.gold("This item holds no corruption to cleanse."))
      player.tags.remove('orb_of_repentance')
      spawnItem('kubejs:orb_of_repentance', 1, player)
      return
    }
    Utils.server.scheduleInTicks(1, () => {
      let stack = player.mainHandItem
      if (!stack || stack.empty || !stack.nbt) return
  
      player.tags.remove('orb_of_repentance')
        
      let cleanseChance = player.hasEffect('kubejs:arcane_luck') ? 0.70 : 0.50
      
      if (Math.random() < cleanseChance) {
        let success = cleanseCorruption(player, stack)
        if (success) {
          player.tell(Text.green("The Repentance Orb purifies the corruption."))
        } else {
          player.tell(Text.gray("This item held no corruption to cleanse."))
        }
      } else {
        // Destroy the item
        player.tell(Text.red("The Repentance Orb rejects the corruption and shatters the item!"))
        Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run playsound blocky_siege:crusher_slam ambient ${player.username} ${Math.floor(player.x)} ${Math.floor(player.y)} ${Math.floor(player.z)} 1 2`)
        Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run playsound minecraft:block.glass.break ambient ${player.username} ${Math.floor(player.x)} ${Math.floor(player.y)} ${Math.floor(player.z)} 1 2`)
        Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run playsound minecraft:block.glass.break ambient ${player.username} ${Math.floor(player.x)} ${Math.floor(player.y)} ${Math.floor(player.z)} 1 1.5`)

        player.setMainHandItem('supplementaries:ash')
      }
    })
  })
  
   */
  



/**
 * ItemEvents.rightClicked('kubejs:sentient_stone', event => {
    if (activeTags.some(tag => event.player.tags.contains(tag))) {
        event.player.tell(Text.red('You are already under the effects of another Orb.'))
        return
    }
    event.player.tags.add('sentient_stone_drop') // Add a tag to the player to signify they have the orb
    event.player.tell(Text.darkGray('Drop the item to infuse it.').italic())
    event.item.count--
    let player = event.player
    Utils.server.runCommandSilent(`/execute at ${player.username} run particle kubejs:sentient_stone ${player.x} ${player.y} ${player.z} 0.5 0.5 0.5 0.2 250`)
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run playsound alexscaves:abyssmarine_glow_on player ${event.player.username} ${event.player.x} ${event.player.y} ${event.player.z} 1 2`)
})


ItemEvents.pickedUp(event => {
    let player = event.player
    if (!player.tags.contains('sentient_stone')) return
    putInMainhand(player, event.item)
    let rarity_check = itemRarityCheck(player, event.item)
    if (rarity_check) {
        player.tell(Text.of([Text.of('This item is already').red(), Text.of(' Common ').gray(), Text.of('rarity').red()]))
        spawnItem('kubejs:sentient_stone', 1, player)
        return
    } else {
        Utils.server.runCommandSilent(`/execute as ${player.username} run apoth set_rarity apotheosis:common`)
    }
    player.tags.remove('sentient_stone')
})
 * 
 * 
 */




/**
 * 
 * // Sentient Stones
ItemEvents.rightClicked(event => {
    if (event.player.tags.toString().includes('sentient_stone')) return
    if (event.player.tags.toString().includes('socketing_chip')) return
    if (!event.item.id.includes('sentient_stone')) return
    let split_id = event.item.id.split(':')[1]
    let rarity = split_id.split('_')[0]
    event.player.tags.add(`${rarity}_sentient_stone`)
    event.player.persistentData.putString('sentient_stone_item', event.item.id)
    event.player.persistentData.putString('sentient_stone_rarity', rarity)
    event.item.count -= 1
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle alexscaves:blue_hazmat_breathe ${event.player.x} ${event.player.y+1} ${event.player.z} 1 1 1 1 500`)
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run playsound alexscaves:abyssmarine_glow_on ambient ${event.player.username} ${event.player.x} ${event.player.y} ${event.player.z} 1 2`)
})

let sentient_dud_messages = [
    "§7Nothing stirs. The weapon stays unchanged.",
    "§7The sentient stone whispers... then goes silent.",
    "§7The energy within the stone remains dormant.",
    "§7The stone flickers, but nothing happens...",
    "§7You feel a faint warmth, but it quickly fades.",
    "§7Fate chooses not to act this time.",
    "§7The sentient stone whispers... then goes silent.",
    "§7The energy within the stone remains dormant.",
    "§7The stone pulses once... and grows cold.",
    "§7A surge of energy builds—then dies."
]
ItemEvents.pickedUp(event => {
    let player = event.player
    let item = event.item
    // Only trigger if the player has a sentient stone tag
    if (
        !player.tags.contains('common_sentient_stone') &&
        !player.tags.contains('uncommon_sentient_stone') &&
        !player.tags.contains('rare_sentient_stone')
    ) return

    // Only apply to valid items
    if (
        !apoth.lootify_valid.some(valid => item.toString().includes(valid)) &&
        !isCurioItem(item)
      ) return
      

    // === RARITY ROLL ===
    let rarity = 'common'

    if (player.tags.contains('common_sentient_stone')) {
        rarity = Math.random() < 0.5 ? 'none' : 'common'
    } else if (player.tags.contains('uncommon_sentient_stone')) {
        rarity = Math.random() < 0.5 ? 'common' : 'uncommon'
    } else if (player.tags.contains('rare_sentient_stone')) {
        let options = ['common', 'uncommon', 'rare']
        rarity = options[Math.floor(Math.random() * options.length)]
    }

    // If rarity rolled "none", display message and clean up
    if (rarity === 'none') {
        let msg = sentient_dud_messages[Math.floor(Math.random() * sentient_dud_messages.length)]
        player.tell(msg)

        player.persistentData.remove('sentient_stone_item')
        player.persistentData.remove('sentient_stone_rarity')
        player.tags.remove('common_sentient_stone')
        player.tags.remove('uncommon_sentient_stone')
        player.tags.remove('rare_sentient_stone')
        return
    }

    // === Move item to main hand ===
    putInMainhand(player, item)

    // === Store sockets before modifying ===
    let old_sockets = player.persistentData.getInt('sockets')

    // === Apply lootify command based on rolled rarity ===
    Utils.server.runCommandSilent(`/execute as ${player.username} run ${apoth.sentient_stone[rarity]}`)

    // === Cleanup stone use ===
    player.persistentData.remove('sentient_stone_item')
    player.persistentData.remove('sentient_stone_rarity')
    player.tags.remove('common_sentient_stone')
    player.tags.remove('uncommon_sentient_stone')
    player.tags.remove('rare_sentient_stone')

    // === Delay to apply socket fix & check for corruption ===
    Utils.server.scheduleInTicks(1, () => {
        let corrupted = player.mainHandItem != null &&
                        player.mainHandItem.nbt != null &&
                        player.mainHandItem.nbt.getBoolean("ChaosAnomalyUsed")

        if (corrupted) {
            player.tell("§7This item has been corrupted by §4Chaos§7, it cannot be modified with a Sentient Stone while it retains this corruption.")

            // Optional: destroy the stone item? Or just end here?
            return
        }

        // Re-apply socket value if it got lowered
        let nbtStr = player.mainHandItem.nbt.toString()
        let new_sockets = 0
        if (nbtStr.includes('sockets:')) {
            let sockets_initial = nbtStr.split('sockets:')[1].split('}')[0].replace(/[^0-9]/g, '')
            new_sockets = parseInt(sockets_initial.split(',')[0])
        }

        if (new_sockets < old_sockets) {
            Utils.server.runCommandSilent(`/execute as ${player.username} run apoth set_sockets ${parseInt(old_sockets)}`)
        }

        player.persistentData.remove('sockets')
    })
})
 * 
 * 
 */
/**
 *  *
let socketingChips = {
  'kubejs:common_socketing_chip': {
    tag: 'common_socketing_chip_drop',
    min: 0,
    max: 1
  },
  'kubejs:uncommon_socketing_chip': {
    tag: 'uncommon_socketing_chip_drop',
    min: 0,
    max: 2
  },
  'kubejs:rare_socketing_chip': {
    tag: 'rare_socketing_chip_drop',
    min: 1,
    max: 3
  }
}

ItemEvents.rightClicked(event => {
  let id = event.item.id
  let chip = socketingChips[id]
  if (!chip) return

  event.player.tags.add(chip.tag)
  event.item.count--
  event.player.tell(Text.gray('§7The socketing chip pulses with intent...'))
})



ItemEvents.pickedUp(event => {
  let player = event.player
  let item = event.item
  let heldItem = player.mainHandItem

  let chipData = Object.entries(socketingChips).find(([_, chip]) =>
    player.tags.contains(chip.tag.replace('_drop', ''))
  )
  if (!chipData) return

  let [chipId, chip] = chipData
  let tagName = chip.tag.replace('_drop', '')

  // Call addSockets — will handle success/failure/refund logic
  addSockets(player, heldItem, getRandomSocketCount(chip), false)

  // Always remove the tag AFTER addSockets runs
  player.tags.remove(tagName)
})

 * 
 * 

















/**
 * 
 * 
 * 
// Socketing Chips
ItemEvents.rightClicked(event => {
    if (event.player.tags.toString().includes('sentient_stone')) return
    if (event.player.tags.toString().includes('socketing_chip')) return
    if (!event.item.id.includes('socketing_chip')) return

    let split_id = event.item.id.split(':')[1]
    let rarity = split_id.split('_')[0]
    let rarity_num = 0

    if (rarity == 'common') {
        rarity_num = Math.random() < 0.5 ? 0 : 1 // 50% chance for 0 or 1
    }
    if (rarity == 'uncommon') {
        rarity_num = Math.random() < 0.5 ? 1 : 2 // 50% chance for 1 or 2
    }
    if (rarity == 'rare') {
        let options = [1, 2, 3]
        rarity_num = options[Math.floor(Math.random() * options.length)] // Random choice from [1,2,3]
    }

    if (rarity_num === 0) {
        event.player.tell(Text.red('The socketing chip cracked and turned to dust...'))
        event.item.count -= 1
        return
    }

    event.player.tags.add(`${rarity}_socketing_chip`)
    event.player.persistentData.putString('socketing_chip_item', event.item.id)
    event.player.persistentData.putInt('socketing_chip_rarity', rarity_num)
    event.item.count -= 1
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle alexscaves:blue_hazmat_breathe ${event.player.x} ${event.player.y+1} ${event.player.z} 1 1 1 1 500`)
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run playsound alexscaves:abyssmarine_glow_on ambient ${event.player.username} ${event.player.x} ${event.player.y} ${event.player.z} 1 2`)
})






ItemEvents.pickedUp(event => {

    if (!event.player.tags.contains('common_socketing_chip') && !event.player.tags.contains('uncommon_socketing_chip') && !event.player.tags.contains('rare_socketing_chip')) return
    if (!apoth.lootify_valid.some(item => event.item.toString().includes(item))) return
    if (event.item.nbt.getBoolean("ChaosAnomalyUsed")) {
        event.player.tell("§cThis item has already been touched by the Chaos Anomaly.")
        return
    }
    let sockets = event.player.persistentData.getInt('sockets')

    Utils.server.scheduleInTicks(1, () => {
        let rarity = event.player.persistentData.getInt('socketing_chip_rarity')
        let newSockets = sockets + rarity

        // Cap total sockets to 5
        if (newSockets > 5) newSockets = 5

        putInMainhand(player, item)

        Utils.server.runCommandSilent(`/execute as ${event.player.username} run apoth set_sockets ${newSockets}`)

        // Clean up data and tags
        event.player.persistentData.remove('sockets')
        event.player.persistentData.remove('socketing_chip_item')
        event.player.persistentData.remove('socketing_chip_rarity')
        event.player.tags.remove('common_socketing_chip')
        event.player.tags.remove('uncommon_socketing_chip')
        event.player.tags.remove('rare_socketing_chip')
    })
})






ItemEvents.dropped(event => {
    //check if its a valid lootify or socketing chip item
    if (!apoth.lootify_valid.some(item => event.item.toString().includes(item)) && !apoth.sockets_valid.some(item => event.item.toString().includes(item))) return
    if (!event.player.tags.toString().includes('sentient_stone') && !event.player.tags.toString().includes('socketing_chip')) return
    let nbt = event.item.nbt.toString()
    let sockets = 0
    if (nbt.includes('sockets:')) {
        // in the nbt, get the sockets
        let sockets_initial = nbt.split('sockets:')[1].split('}')[0].replace(/[^0-9]/g, '')
        // remove everything after the comma
        sockets = parseInt(sockets_initial.split(',')[0])
    }
    //Utils.server.tell(sockets)
    event.player.persistentData.putInt('sockets', sockets)

    Utils.server.scheduleInTicks(15, e => {
        if (event.itemEntity.blockStateOn.block.id != 'irons_spellbooks:scroll_forge') return
        event.level.spawnLightning(event.itemEntity.x, event.itemEntity.y, event.itemEntity.z, true)
        event.level.spawnLightning(event.itemEntity.x, event.itemEntity.y, event.itemEntity.z, true)
        event.level.spawnLightning(event.itemEntity.x, event.itemEntity.y, event.itemEntity.z, true)
        Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle irons_spellbooks:spark 1 0.5 0 ${event.itemEntity.x} ${event.itemEntity.y} ${event.itemEntity.z} 0.2 0.2 0.2 0.3 500`)
    })
})
 * 
 * 
 */
  /**
   *  // === Orb of Socketing Activation ===
  ItemEvents.rightClicked('kubejs:orb_of_socketing', event => {
    if (activeTags.some(tag => event.player.tags.contains(tag))) {
      event.player.tell(Text.red('You are already under the effects of another Orb.'))
      return
  }
    const player = event.player
    player.tags.add('orb_of_socketing_drop')
    event.item.count -= 1
  
    // Visual and audio feedback
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run playsound born_in_chaos_v1:charm_of_protection_use ambient ${event.player.username} ${event.player.x} ${event.player.y} ${event.player.z} 1 1.5`)
    Utils.server.runCommandSilent(`/execute at ${player.username} run particle undead_unleashed:moonlight_glint ${player.x} ${player.y+1} ${player.z} 0.1 0.1 0.1 0.1 100`)

  })
  
  
  // === Orb of Socketing Drop Handling ===
  ItemEvents.pickedUp(event => {
    const player = event.player
    const item = event.item
  
    if (!player.tags.contains('orb_of_socketing')) return
    if (
      !apoth.lootify_valid.some(valid => item.toString().includes(valid)) &&
      !isCurioItem(item)
    ) return
    
  
    Utils.server.scheduleInTicks(1, () => {
      const item = player.mainHandItem
      if (!item || !item.nbt) return
  
      // Remove tag
      player.tags.remove('orb_of_socketing')
  
      const currentSockets = item.nbt?.affix_data?.sockets ?? 0
      const rarity = item.nbt?.affix_data?.rarity ?? 'apotheosis:common'
      const maxForRarity = raritySocketCaps[rarity] ?? 1
  
      if (currentSockets >= maxForRarity) {
        player.tell(Text.red(`This item needs a higher rarity to hold more sockets.`))
        spawnItem('kubejs:orb_of_socketing', 1, player)
        return
      }
  
      // Socket upgrade chances
      const chances = {
        0: 1.00,
        1: 0.80,
        2: 0.60,
        3: 0.40,
        4: 0.30,
        5: 0.20,
        6: 0.10,
        7: 0.05,
      }
  
      const upgradeChance = chances[currentSockets] ?? 0
      if (Math.random() < upgradeChance) {
        let newSockets = currentSockets + 1
        Utils.server.runCommandSilent(`/execute as ${player.username} run apoth set_sockets ${newSockets}`)
        player.tell(Text.of([
          Text.of('[Socket Added]: ').gray(),
          Text.of(`${currentSockets}`).red(),
          Text.of(' → ').gray(),
          Text.of(`${newSockets}`).green()
        ]).italic())
      } else {
        player.tell(Text.gray('The Orb crumbles to dust...'))
      }
    })
  })
   * 
   * 
   * 
   */
   /**
   * // === Step 1: Activate Mage Orb use ===
ItemEvents.rightClicked('kubejs:orb_of_sorcery', event => {
    if (activeTags.some(tag => event.player.tags.contains(tag))) {
        event.player.tell(Text.red('You are already under the effects of another Orb.'))
        return
    }
    let player = event.player
    let orb = event.item
    event.player.tell(Text.gray('Drop the item to upgrade it.').italic())

    player.tags.add('orb_of_sorcery_drop')
    orb.count--
    Utils.server.runCommandSilent(`/execute at ${player.username} run particle bosses_of_mass_destruction:magic_circle ${player.x} ${player.y} ${player.z} 1 1 1 0.2 30 force ${player.username}`)
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run playsound alexscaves:abyssmarine_glow_on ambient ${event.player.username} ${event.player.x} ${event.player.y} ${event.player.z} 1 1.3`)
})



// === Orb of Sorcery Pickup Handler ===
ItemEvents.pickedUp(event => {
    let player = event.player
    if (!player.tags.contains('orb_of_sorcery')) return

    let item = event.item
    if (!item || !item.nbt || !item.nbt.ISB_Spells || !item.nbt.ISB_Spells.data || item.nbt.ISB_Spells.data.length === 0) {
        player.tell(Text.red("That item holds no spells to enhance."))
        spawnItem('kubejs:orb_of_sorcery', 1, player)
        player.tags.remove('orb_of_sorcery')
        return
    }

    // Move item to main hand
    putInMainhand(player, item)

    item = player.mainHandItem

    Utils.server.scheduleInTicks(1, () => {
        upgradeImbuedSpell(player, item)
    })

    // Cosmetic
    Utils.server.runCommandSilent(`/execute at ${player.username} run playsound irons_spellbooks:spell.thunderstorm.prepare ambient ${player.username} ${player.x} ${player.y} ${player.z} 1 1.5`)
    Utils.server.runCommandSilent(`/execute at ${player.username} run particle irons_spellbooks:unstable_ender ${player.x} ${player.y} ${player.z} 0.2 0.2 0.2 0.5 200 force ${player.username}`)
})
   * 
   * 
   * 
   * 
   */















